(define/contract (min-eating-speed piles h)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define (can-eat-all k)
    (let loop ([piles piles] [hours 0])
      (if (null? piles)
          (<= hours h)
          (let ([p (car piles)])
            (loop (cdr piles) (+ hours (quotient (+ p k -1) k))))))))
  (let binary-search ([left 1] [right (apply max piles)])
    (if (= left right)
        left
        (let ([mid (quotient (+ left right) 2)])
          (if (can-eat-all mid)
              (binary-search left mid)
              (binary-search (+ mid 1) right))))))